MathType for TinyMCE4 [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/wirismath)
===

Type and handwrite mathematical notation with MathType.

Easily include quality math equations in your documents and digital content.

![MathType for TinyMCE 4 screenshot](http://www.wiris.com/system/files/attachments/1202/TinyMCE_editor_plugin.png)

# Table of Contents

- [Install instructions](#install-instructions)
- [Services](#services)
- [Documentation](#documentation)
- [Displaying on Target Page](#displaying-on-target-page)
- [Privacy policy](#privacy-policy)

## Install instructions

1. Install the npm module:

   ```
   npm install @wiris/mathtype-tinymce4
   ```
2. Add the plugin as an external plugin:

   ```js
   tinymce.init({
     external_plugins: {
       'tiny_mce_wiris' : 'http://localhost/project/npm-tinymce4/node_modules/@wiris/mathtype-tinymce4/plugin.min.js'
     }
   });
   ```

   Please, note the URL must be absolute due to a TinyMCE4 issue. See [TinyMCE4 tracker](https://github.com/tinymce/tinymce/issues/3056) for further information.
3. Add MathType buttons to the TinyMCE4 toolbar:

   ```js
   tinymce.init({
     toolbar: 'tiny_mce_wiris_formulaEditor,tiny_mce_wiris_formulaEditorChemistry',
   });
   ```

   Notice the example assumes this directory structure:

   ```
    └───index.html
    └───node_modules
        └───@wiris/mathtype-tinymce4
   ```

## Services

This npm module uses remotely hosted services to render MathML data. However, we recommend you install these services on your backend. This will allow you, among other things, to configure the service and to locally store the images generated by MathType.

The services are available for Java, PHP, .NET and Ruby on Rails. If you use any of these technologies, please download the plugin for your backend technology from [here](http://www.wiris.com/en/plugins3/tinymce/download).

In order to install the plugin along with the correspondent services, please follow the [TinyMCE4 install instructions](http://docs.wiris.com/en/mathtype/mathtype_web/integrations/html/tinymce).

## Displaying on Target Page

In order to display mathematical formulas on the target page, i.e. the page where content produced by the HTML editor will be visible, the target page needs to include the [MathType script](https://docs.wiris.com/en/mathtype/mathtype_web/integrations/mathml-mode#add_a_script_to_head). For example for the default setting this would be:
```html
<script src="https://wiris.net/demo/plugins/app/WIRISplugins.js?viewer=image"></script>
```

## Documentation

To find out more information about MathType, please go to the following documentation:

* [Install instructions](http://docs.wiris.com/en/mathtype/mathtype_web/integrations/html/tinymce)
* [MathType documentation](http://docs.wiris.com/en/mathtype/mathtype_web/start)
* [Introductory tutorials](http://docs.wiris.com/en/mathtype/mathtype_web/intro_tutorials)
* [Service customization](http://docs.wiris.com/en/mathtype/mathtype_web/integrations/config-table)
* [Testing](http://docs.wiris.com/en/mathtype/mathtype_web/integrations/html/plugins-test)

## Privacy policy

The [MathType Privacy Policy](http://www.wiris.com/mathtype/privacy-policy) covers the data processing operations for the MathType users. It is an addendum of the company’s general Privacy Policy and the [general Privacy Policy](https://wiris.com/en/privacy-policy) still applies to MathType users.
